TEMPLATE = lib
TARGET = installer
INCLUDEPATH += . ..

# productkeycheck API
# call qmake "PRODUCTKEYCHECK_PRI_FILE=<your_path_to_pri_file>"
# content of that pri file needs to be:
#   SOURCES += $$PWD/productkeycheck.cpp
#   ...
#   your files if needed
HEADERS += productkeycheck.h
!isEmpty(PRODUCTKEYCHECK_PRI_FILE) {
    # use undocumented no_batch config which disable the implicit rules on msvc compilers
    # this fixes the problem that same cpp files in different directories are overwritting
    # each other
    CONFIG += no_batch
    include($$PRODUCTKEYCHECK_PRI_FILE)
} else {
    SOURCES += productkeycheck.cpp
}

DESTDIR = $$IFW_LIB_PATH
DLLDESTDIR = $$IFW_APP_PATH

DEFINES += BUILD_LIB_INSTALLER

QT += \
    qml \
    network \
    xml \
    concurrent \
    widgets \
    core-private
win32:QT += winextras

HEADERS += packagemanagercore.h \
    packagemanagercore_p.h \
    packagemanagergui.h \
    packagemanagerpage.h \
    packagemanagerintroductionpage.h \
    packagemanagerselectlanguagepage.h \
    packagemanagerreadyforinstallationpage.h \
    packagemanagerstartmenudirectorypage.h \
    packagemanagerrestartpage.h \
    packagemanagerpaerforminstallationpage.h \
    packagemanagerlicenceagreementpage.h \
    packagemanagertargetdirectorypage.h \
    packagemanagerdynamicinstallerpage.h \
    packagemanagercheckinstallationsingletonpage.h \
    packagemanagerfinishedpage.h \
    packagemanagercomponentselectionpage.h \
    messageboxhandler.h

SOURCES += packagemanagercore.cpp \
    packagemanagercore_p.cpp \
    packagemanagergui.cpp \
    packagemanagerpage.cpp \
    packagemanagerintroductionpage.cpp \
    packagemanagerselectlanguagepage.cpp \
    packagemanagerreadyforinstallationpage.cpp \
    packagemanagerstartmenudirectorypage.cpp \
    packagemanagerrestartpage.cpp \
    packagemanagerpaerforminstallationpage.cpp \
    packagemanagerlicenceagreementpage.cpp \
    packagemanagertargetdirectorypage.cpp \
    packagemanagerdynamicinstallerpage.cpp \
    packagemanagercheckinstallationsingletonpage.cpp \
    packagemanagerfinishedpage.cpp \
    packagemanagercomponentselectionpage.cpp \
    messageboxhandler.cpp \
    installerbase.cpp

RESOURCES += resources/installer.qrc

unix {
    osx: SOURCES += adminauthorization_mac.cpp
    else: SOURCES += adminauthorization_x11.cpp
}

LIBS += -l7z
win32 {
    SOURCES += adminauthorization_win.cpp sysinfo_win.cpp

    LIBS += -loleaut32 -luser32     # 7zip
    LIBS += -ladvapi32 -lpsapi      # kdtools
    LIBS += -lole32 -lshell32       # createshortcutoperation

    win32-g++*:LIBS += -lmpr -luuid
    win32-g++*:QMAKE_CXXFLAGS += -Wno-missing-field-initializers
}

target.path = $$[QT_INSTALL_LIBS]
INSTALLS += target
